﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;

namespace MonitorExamples
{
    class Program
    {
        // Listing 16-10. Testowanie klasy MostRecentlyUsed
        const int Iterations = 10000;

        static void TestMru(MostRecentlyUsed mru)
        {
            // Inicjalizacja generatora liczb losowych przy użyciu identyfikatora
            // wątku zapewnia, że każdy wątek będzie używał innych danych 
            // (choć z drugiej strony sprawia, że każdy test będzie miał 
            // inny przebieg, co nie jest idealnym rozwiązaniem).
            Random r = new Random(Thread.CurrentThread.ManagedThreadId);
            string[] items = { "jeden", "dwa", "trzy", "cztery", "pięć",
                       "sześć", "siedem", "osiem" };
            for (int i = 0; i < Iterations; ++i)
            {
                mru.UseItem(items[r.Next(items.Length)]);
            }
        }

        static void Main(string[] args)
        {
            // Listing 16-11. Test wykonywany z wykorzystaniem większej liczby wątków
            MostRecentlyUsed mru = new MostRecentlyUsed(4);

            const int TestThreadCount = 2;
            List<Thread> threads = (from i in Enumerable.Range(0, TestThreadCount)
                                    select new Thread(() => TestMru(mru))).ToList();

            threads.ForEach(t => t.Start());
            threads.ForEach(t => t.Join());

            foreach (string item in mru.GetItems())
            {
                Console.WriteLine(item);
            }
        }
    }
}
